/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class OreBucketItem
extends BucketItem {
    private static final String NBT_TAG = "Tag";

    public OreBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NBT_TAG)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidBucketWrapper(stack){

            @Nonnull
            public FluidStack getFluid() {
                FluidStack stack = new FluidStack(OreBucketItem.this.getFluid(), 1000);
                if (this.container.m_41784_().m_128441_(OreBucketItem.NBT_TAG)) {
                    String tag = this.container.m_41784_().m_128461_(OreBucketItem.NBT_TAG);
                    stack.getOrCreateTag().m_128359_(OreBucketItem.NBT_TAG, tag);
                }
                return stack;
            }
        };
    }

    public Component m_7626_(ItemStack stack) {
        TranslatableComponent displayName = new TranslatableComponent(this.m_5671_(stack));
        return displayName;
    }
}

